"Macro Data Sheet file v. 1"
gamesystem GURPS

title "GURPS Supers Second Edition (v. 3.0.0)"

version 253
level 3

copyright "Copyright  1989, 1991, 1996, 2001 Steve Jackson Games Incorporated. All rights reserved. \
GURPS is a registered trademark of Steve Jackson Games Incorporated."

$$define PLUGIN SU
$$include gurps.inc

logo GURPS/Supers.lgo
help gurps.hlp


$$macro stdrange(dummy)
{{
	opt exp Range "`Touch Only`?0:integer(`Power`*10/2^(-`Reduced Range`/5))" end
}}

$$macro areaeff(dummy) 
{{
	opt exp "Area of Effect" "max(1,integer(`Power`/5))+`Increased Area`/20" end
	$$stdrange()
}}


cat Advantages

sublist "Mundane Advantages" memlist
	$$ladv("IST Membership Rank", 65+4/level, , 65+5*x)
	end



sublist "Super Equipment" memlist
	$$sublist(Gadget)
		totalcostformula "ceil((c+a)*m)"
	$$sublist(Battlesuit)
		totalcostformula "ceil((c+a)*m)"
	$$EnhAttr(Enhanced DX)
	$$EnhAttr(Enhanced IQ)
	$$EnhAttr(Enhanced HT)
	$$EnhAttr(Enhanced ST)
		adj "p_st+`Override ST`?x:0"
		opt	begin text "Override ST" "?+0;" noprint dispexp 'l' end
			exp Swing "swing(x, 0)"
			exp Thrust "thrust(x, 0)"
			end
	end
end

cat "Powers"
	sublist "Absorb Attribute" memlist
		$$suppow("Absorb DX", RM, 5, iq)
			$$stdrange()
		$$suppow("Absorb HT", RM, 5, iq)
			$$stdrange()
		$$suppow("Absorb IQ", RM, 5, iq)
			$$stdrange()
		$$suppow("Absorb ST", RM, 5, iq)
			$$stdrange()
		end
	$$suppow("Absorb Matter", RP, 7, dx)
		opt	percent "Limited to One Form"	?+0;-30%
			end
		$$stdrange()
	$$suppow(Alter, RM, 5, iq)
		opt
			percent "Analyze Not Required" "?+0;+30%"
			end
		$$stdrange()
	$$suppow(Analyze, RM, 1, iq)
		$$stdrange()
	$$suppow(Animate, RM, 4, iq)
		$$stdrange()
	$$suppow("Animate Plant", AM, 3, iq)
		$$areaeff()
	$$suppow("Animate Shadow", RM, 5, iq)
		$$stdrange()
	$$suppow(Anti-G, RM, 3, iq)
		$$stdrange()
	$$suppow(Bind, RP, 6, dx)
		opt
			percent "Victim Only Frozen in Place" "?+0;-40%"
			percent "Victim Must Be Touching Ground" "?+0;-20%"
			end
		$$stdrange()

	$$suppow(Blind, RP, 5, dx)
		$$stdrange()
	$$suppow(Bond, RP, 5, dx)
		$$stdrange()
	$$suppow(Buzzsaw, RP, 8, dx, , , "^n (^o'Damage')")
		$$supdmg(`Power`<6?'cr':'imp', "thr(`Power`)")
		$$stdrange()
	$$suppow("Call Hail", AM, 1, iq)
		$$areaeff()
	$$suppow(Color, RM, 1, iq)
		$$stdrange()
	$$suppow(Confuse, RM, 4, iq)
		$$stdrange()
	$$suppow("Control Animal", RM, 3, iq)
		opt percent "Single Type of Animal" ?+0;-60% end
		$$stdrange()
	$$suppow("Control Animated Object", RM, 3, iq)
		$$stdrange()
	$$suppow("Control Fire", RM, 3, iq)
		$$stdrange()
	$$suppow("Control Fish", RM, 1, iq)
		$$stdrange()
	$$suppow("Control Liquid", AM, 1, iq)
		$$areaeff()
	$$suppow("Control Plant", RM, 2, iq)
		$$stdrange()
	$$suppow("Control Temperature", AM, 1, iq)
		$$areaeff()
	$$suppow("Control Weather", AM, 5, iq)
		$$areaeff()
	$$suppow("Control Winds", AM, 2, iq)
		$$areaeff()
	$$suppow(Cool, AM, 1, iq)
		$$areaeff()
	$$suppow("Create Air", AP, 1, dx)
		$$areaeff()
	$$suppow("Create Darkness", AP, 3, dx)
		$$areaeff()
	$$suppow("Create Gas", AP, 3, dx)
		$$areaeff()
	$$suppow("Damage Control", SP, 3, dx)
	$$suppow(Dampen, AM, 3, iq)
		$$areaeff()
	$$suppow(Deafen, RP, 3, dx)
		$$stdrange()
	$$suppow("Decrease Density", RM, 6, iq)
		$$stdrange()
	$$suppow(Dehydrate, RP, 8, dx)
		$$stdrange()
	$$suppow("Destroy Liquid", AP, 1, dx)
		$$areaeff()
	$$suppow(Disintegrate, RP, 8, dx)
		$$stdrange()
	$$suppow("Drain Skill", RM, 3, iq)
		$$stdrange()
	$$suppow("Drain Super Ability", RM, 8, iq)
		$$stdrange()
	$$suppow(Fireball, RP, 6, dx, , , "^n (^o'Damage')")
		$$supdmg('fire')
		$$stdrange()
	$$suppow("Flame Jet", RP, 6, dx, , , "^n (^o'Damage')")
		$$supdmg('fire')
		$$stdrange()
	$$suppow(Flash, AM, 4, iq)
		$$areaeff()
	$$suppow("Frost Jet", RP, 6, dx, , , "^n (^o'Damage')")
		$$supdmg('cold')
		$$stdrange()
	$$suppow(Healing, RM, 3, iq)
		$$stdrange()
	$$suppow("Ice Spear", RP, 9, dx, , , "^n (^o'Damage')")
		$$supdmg('imp', "format('%dd-%d',`Power`,`Power`)")
		$$stdrange()
	$$suppow("Ice Sphere", RP, 6, dx, , , "^n (^o'Damage')")
		$$supdmg()
		$$stdrange()
	$$suppow("Ice Wall", RP, 4, dx)
		$$stdrange()
	$$suppow("Icy Surface", AP, 4, dx)
		$$areaeff()
	$$suppow(Illuminate, AM, 1, iq)
		$$areaeff()
	$$suppow(Illusion, RM, 5, iq)
		opt
			percent "Animate Illusions" ?+0;+20%
			percent "Move Illusions" ?+0;+20%
			end
		$$stdrange()
	$$suppow("Increase Density", RM, 4, iq)
		$$stdrange()
	$$suppow("Increase Gravity", RM, 6, iq)
		$$stdrange()
	$$suppow(Laser, RP, 9, dx, , , "^n (^o'Damage')")
		$$supdmg('imp')
		$$stdrange()
	$$suppow(Lightning, RP, 7, dx, , , "^n (^o'Damage')")
		$$supdmg('electrical')
		$$stdrange()
	$$suppow(Magnetize, RM, 5, iq)
		opt percent "Affect Ferrous Metals Only" ?+0;-30%
			end
		$$stdrange()
	$$suppow("Metabolism Control", SP, 1, dx)
	$$suppow("Mimic Skill", RM, 2, iq)
		$$stdrange()
	$$suppow("Mimic Super Ability", RM, 7, iq)
		$$stdrange()
	$$suppow(Mimicry, SP, 2, dx)
	$$suppow("Mold Earth", AM, 4, iq)
		$$areaeff()
	$$suppow("Mold Stone", RM, 4, iq)
		$$stdrange()
	$$suppow("Morph", SM, 40+3/level, iq, , "40+(x-1)*3")
		opt
			exp "Max. Mass" "format(\"+%d%%\",`Power`*10)"
			exp "Min. Mass" "format(\"-%d%%\",min(`Power`*10,90))"
			percent "Doesn't Need Morph Memory" ?+0;+100%
			end
	$$suppow("Morph Memory", SM, 2, iq)
	$$suppow("Neutralize Fire", AP, 2, dx)
		$$areaeff()
	$$suppow("Neutralize Sound", AP, 2, dx)
		$$areaeff()
	$$suppow("Plant Growth", AM, 3, iq)
		$$areaeff()
	$$suppow("Ring of Fire", AP, 3, dx)
		$$areaeff()
	$$suppow("Sand Jet", RP, 4, dx)
		$$stdrange()
	$$suppow("Sense Animal", AM, 1, iq)
		$$areaeff()
	$$suppow("Sense Fish", AM, 1, iq)
		$$areaeff()
	$$suppow("Sense Plant", AM, 1, iq)
		$$areaeff()
	$$suppow("Sense Super Power", AM, 3, iq)
		$$areaeff()
	$$suppow("Shape Ice", AM, 1, iq)
		$$areaeff()
	$$suppow(Shockwave, AP, 8, dx, , , "^n (^o'Damage')")
		$$supdmg()
		$$areaeff()
	$$suppow(Smoke, AP, 3, dx)
		$$areaeff()
	$$suppow("Sonic Blast", RP, 7, dx, , , "^n (^o'Damage')")
		$$supdmg('sonic')
		opt
			percent "Not Armor-Piercing vs. Metal and Crystal" ?+0;-20%
			end
		$$stdrange()
	$$suppow("Stone Missile", RP, 6, dx, , , "^n (^o'Damage')")
		$$supdmg()
		$$stdrange()
	$$suppow(Surge, RM, 4, iq)
		$$stdrange()
	$$suppow(Vacuum, AP, 4, dx)
		$$areaeff()
	$$suppow("Vibratory Blast", RP, 9, dx, , , "^n (^o'Damage')")
		$$supdmg('imp')
		opt
			percent "Not Armor-Piercing vs. Metal and Crystal" ?+0;-20%
			end
		$$stdrange()
	$$suppow("Wall of Fire", RP, 5, dx)
		$$stdrange()
	$$suppow(Warm, AM, 2, iq)
		$$areaeff()
	$$suppow("Water Cannon", RP, 6, dx, , , "^n (^o'Damage')")
		$$supdmg()
		$$stdrange()
	$$suppow("Water Jet", RP, 5, dx, , , "^n (^o'Damage')")
		$$supdmg('KB', "format('%dd+half cr', `Power`)")
		$$stdrange()
	$$suppow("Wave of Earth", RP, 6, dx, , , "^n (^o'Damage')")
		$$supdmg()
		$$stdrange()
	$$suppow(Whirlwind, AP, 5, dx)
		$$areaeff()
	$$suppow("Wind Blast", RP, 6, dx, , , "^n (^o'Damage')")
		$$supdmg()
		$$stdrange()
	$$suppow("Wind Jet", RP, 4, dx, , , "^n (^o'Damage')")
		$$supdmg('KB', "format('%dd',`Power`*2)")
		$$stdrange()
	end

cat Equipment
	sublist Armor memlist
		sublist "Modern and Ultra-Tech" memlist
			$$armor	Medium Body Armor	8	6	25	2000	30	Head,Body,Arms,Legs,Hands,Feet,Whole
			end
		end
	end

options
	list "Super Equipment"
		percent Breakable "?:2;DR<=15/HP<=75, -15%;DR>15/HP>75, -5%"
		percent "Can Be Hit" "?:2;-10 Penalty,+0%;-8 Penalty,-5%;-6 Penalty,-10%;-4 Penalty,-15%;-2 Penalty,-20%;No Penalty,-25%"
		percent "Can Be Stolen By" "?:1;Stealth or Trickery,-10%;DX Contest,-30%;ST Contest,-20%;DX Roll,-40%"
		percent "Cannot Be Repaired" -15%
		percent "Fixed Location" -50%
		percent Unique -25%
		percent "Unreliable: Activation" "?:2;15+,+0%;13,-5%;11,-10%;9,-15%;8,-20%"
		percent "Unremovable (Advantage)" +10%
		percent "Unremovable (Disadvantage)" -10%
		percent Vehicular -25%
		end
	end
end
